package sprzedaz.strumieniowo;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class P4_Grupowanie_v3 {

    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");
        
        Map<String, DoubleSummaryStatistics> mapa = transakcje.stream()
                .collect(Collectors.groupingBy(Transakcja::getMiasto,
                        Collectors.summarizingDouble(Transakcja::getWartoscDouble)));
        
        // mapa.forEach((miasto, suma) -> System.out.println(miasto + ": " + suma));

        mapa.forEach((miasto, stats) -> System.out.printf("| %-12s| %6d | %12.2f | %8.2f | %10.2f | %10.2f |\n",
                miasto, stats.getCount(), stats.getSum(), stats.getMin(), stats.getAverage(), stats.getMax()));
    }

}
