package sprzedaz.obiektowo;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class P4_Grupowanie_v1 {
    
    // pierwsze podjeście - zbieram nazwy miast bez powtórzeń i następnie dla każdego miasta
    // wyliczam sumę sposobem takim, jak w P2
    // Wada: wielokrotnie przeglądam całą listę
    
    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");
        
        Set<String> miasta = new TreeSet<>();
        for(Transakcja transakcja : transakcje) {
            miasta.add(transakcja.getMiasto());
        }
        
        for(String miasto : miasta) {
            double suma = 0;
            for(Transakcja transakcja : transakcje) {
                if(transakcja.getMiasto().equals(miasto)) {
                    suma += transakcja.getWartoscDouble();
                }
            }
            System.out.printf("| %-10s | %11.2f |\n", miasto, suma);
        }
    }

}



