package sprzedaz.obiektowo;

import java.util.ArrayList;
import java.util.List;

public class P3_Miasta_v1 {
    
    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");
        List<String> miasta = new ArrayList<>();
        
        // nanoTime - odczyt zegara systemowego.
        // robimy to po to, aby zmierzyć czas działania
        long p = System.nanoTime();
        for(Transakcja transakcja : transakcje) {
            if(!miasta.contains(transakcja.getMiasto())) {
                miasta.add(transakcja.getMiasto());
            }
        }
        long k = System.nanoTime();
        
        for(String miasto : miasta) {
            System.out.println(miasto);
        }
        System.out.printf("Czas: %.6f s\n", (k-p) * 1e-9);
    }

}



