package rozwiazania_zadan.r2.z1.p4_pierwsze;

import java.util.Scanner;

public class LiczbyPierwsze1 {
	// Z definicji liczby pierwszej: to jest taka liczba naturalna, która ma dokładnie 2 dzielniki
	// (1 i siebie samą, przy czym 1 NIE JEST uznawane za liczbę pierwszą).
	
	// Ta wersja sprawdza ile jest dzielników; jeśli 2, to znaczy, że liczba pierwsza.
	// Wada: długo działa dla dużych liczb. Niezależnie od tego czy liczba jest pierwsza, czy nie, i tak musi dojść do samego końca.
	
	static boolean czyPierwsza(long liczba) {
		long ileDzielnikow = 0;
		for(long i = 1; i <= liczba; i++) {
			if(liczba % i == 0) {
				ileDzielnikow++;
			}
		}
		System.out.println("ilość dzielników: " + ileDzielnikow);
		return ileDzielnikow == 2; // tylko wtedy liczba jest pierwsza
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		System.out.println("Aby zakończyć, wpisz 0");
		while(true) {
			System.out.print("Podaj liczbę: ");
			long liczba = sc.nextLong();
			if(liczba == 0) break;
			
			// pomiar czasu
			long p = System.currentTimeMillis();
			boolean wynik = czyPierwsza(liczba);
			long k = System.currentTimeMillis();
			
			if(wynik) {
				System.out.println("Liczba " + liczba + " jest pierwsza");
			} else {
				System.out.println("Liczba " + liczba + " nie jest pierwsza");
			}
			System.out.println("Sprawdzenie trwało " + (k-p) + " ms");
			System.out.println();
		}

	}

}
