package alx.p43_files;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DStream {
	// DirectoryStream nie wchodzi do podkatalogów
	public static void main(String[] args) throws IOException {
		Path dir = Paths.get("src");
		DirectoryStream<Path> dstream = Files.newDirectoryStream(dir);
		for(Path p : dstream) {
			System.out.println(p);
		}
		System.out.println("======");
		// W DirectoryStream nie działają wildcardy wielopoziomowe (nie schodzi do podkatalogów)
		dstream = Files.newDirectoryStream(dir, "**.java");
		for(Path p : dstream) {
			System.out.println(p);
		}
		System.out.println("======");
		dstream = Files.newDirectoryStream(dir.resolve("main/java/alx/p43_files"), "*.java");
		for(Path p : dstream) {
			System.out.println(p);
		}
	}
}
