package alx.p40_io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class InputStream_Markowanie {

	public static void main(String[] args) {
		try {
			FileInputStream in = new FileInputStream("plik.txt");
			//FileInputStream in = new FileInputStream("pan-tadeusz.txt");
			
			// Zwykły FileInputStream nie wspiera markowania
			System.out.println("1 markSupported: " + in.markSupported());
			
			// BufferedInputStream jest przykładem klasy opakowującej inne strumienie
			BufferedInputStream bin = new BufferedInputStream(in);
			System.out.println("1 markSupported: " + bin.markSupported());
			System.out.println();
			
			byte[] bajty = new byte[100];
			
			System.out.println("Wczytuję 4 pierwsze bajty");
			// od pozycji 0 w tablicy wstaw do niej maksymalnie 4 bajty
			bin.read(bajty, 0, 4);
			System.out.println(new String(bajty, 0, 4));
			
			System.out.println("\nmarkuję to miejsce");
			bin.mark(10); // 10 oznacza, że mogę pójść 10 bajtów do przodu, a potem się cofnąć
			
			System.out.println("Wczytuję 7 kolejnych bajtów");
			bin.read(bajty, 0, 7);
			System.out.println(new String(bajty, 0, 7));
			
			System.out.println("\nreset! - czyli cofam się w miejsce zamarkowane");
			bin.reset();
			
			System.out.println("Wczytuję plik do końca:");
			bin.read(bajty);
			System.out.println(new String(bajty, 0, 7));
			
			System.out.println("\nKoniec...");
						
			in.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
