package alx.p31_streamy.emps;

import java.io.File;
import java.util.List;
import java.util.OptionalDouble;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P4_SredniaJob_v3 {

	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setDialogTitle("Wybierz plik z danymi pracowników");
		chooser.setFileFilter(new FileNameExtensionFilter("Pliki CSV", "csv", "txt"));
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			return;
		}
		File wybranyPlik = chooser.getSelectedFile();
		
		List<Employee> emps = ObslugaCSV.wczytaj(wybranyPlik);
		
		Object[] jobs = emps.stream()
			.map(Employee::getJobTitle)
			.distinct()
			.sorted()
			.toArray();
		
		String wybranyJob = (String)JOptionPane.showInputDialog(null,
				"Czyją średnią chcesz obliczyć?",
				"Wybierz stanowsiko",
				JOptionPane.QUESTION_MESSAGE,
				null,
				jobs,
				null);
		
		OptionalDouble srednia = emps.stream()
			.filter(emp -> emp.getJobTitle().equalsIgnoreCase(wybranyJob))
			.mapToInt(Employee::getSalary)
			.average();
		
		if(srednia.isPresent()) {
			JOptionPane.showMessageDialog(null, "Średnia pracowników typu " + wybranyJob + ": " + srednia.getAsDouble());
		} else {
			JOptionPane.showMessageDialog(null, "Nie ma żadnego pracownika na stanowisku " + wybranyJob, "Brak danych", JOptionPane.WARNING_MESSAGE);
		}
	}

}
