package alx.p31_streamy.emps;

import java.util.List;
import java.util.stream.Collectors;

public class P2_FiltrowanieDoListyString {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");

		List<String> wyniki = emps.stream()
				.filter(emp -> emp.getSalary() >= 10_000)
				.map(emp -> String.format("Pracownik %s %s (%s) zarabia %d USD",
						emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary()))
				.collect(Collectors.toList());
		
		wyniki.forEach(System.out::println);
	}

}
