package alx.p31_streamy.emps;

import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Grupowanie3 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Parametr TreeMap::new to jest "przepis na pusty słownik" i chodzi tu o to, aby został uzyty TreeMap zamiast HashMap.
		// Dane są posortowane.
		
		// Dla każdej grupy obliczymy tutaj "statystyki" a nie tylko średnią.
		
		Map<String, IntSummaryStatistics> srednie = emps.stream()
				.collect(Collectors.groupingBy(Employee::getJobTitle,
						TreeMap::new,
						Collectors.summarizingInt(Employee::getSalary)));
		
		System.out.println(" Stanowisko                       | ile|      min |  średnia |      max |       suma |");
		srednie.forEach((job, stats) -> System.out.printf(" %-32s | %2d | %8d | %8.2f | %8d | %10d |\n",
				job, stats.getCount(), stats.getMin(), stats.getAverage(), stats.getMax(), stats.getSum()));
	}

}
