package alx.p31_streamy.emps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie1 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, List<Employee>> grupy = emps.stream().collect(Collectors.groupingBy(Employee::getJobTitle));
		// Dla każdego stanowiska mamy listę pracowników.
		// Zawartość tych kolekcji wypiszemy również w sposób "funkcyjny":
		
		grupy.forEach((job, lista) -> {
			System.out.println("Pracownicy na stanowisku " + job + ": ");
			lista.forEach(emp -> {
				System.out.println(" * " + emp.getFirstName() + " " + emp.getLastName());
			});
			System.out.println();
		});
	}

}
