package alx.p31_streamy.emps;

import java.util.List;

public class FilterMap_v2 {
	// Operacje na strumieniach zwykle łączy się w tzw. "pipeline", który:
	// - zaczyna się od operacji tworzącej strumień
	// - dalej posiada 0 lub więcej operacji pośrednich
	// - na końcu ma operację terminującą.
	
	// W tym przykładzie przeplatamy najbardziej standardowe operacje na strumieniach:
	// filter - sprawdza czy element strumienia spełnia warunek i tylko jeśli tak, to przepuszcza do następnego etapu
	// map - na podstawie elementu wejściowego zwraca jakiś wynik, który jest przekazywany do nast. etapu
	
	// W tej wersji tam, gdzie można, zamiast wyrażenia lambda -> zastosujemy method reference ::
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		emps.stream()
			.filter(emp -> emp.getSalary() >= 10000)
			.filter(emp -> "Seattle".equals(emp.getCity()))
			.map(emp -> emp.getFirstName() + " " + emp.getLastName())
			.filter(s -> s.contains("a"))
			.map(String::toUpperCase)
			.forEach(System.out::println);
	}

}
