package watki.podstawy;

public class Konto {
    private final int numer;
    private int saldo;
    private Osoba wlasciciel;
    
    public Konto(int numer, int saldo, Osoba wlasciciel) {
        if(saldo < 0) {
            throw new IllegalArgumentException("Ujemna kwota w konstruktorze");
        }
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    public Osoba getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(Osoba wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public synchronized int getSaldo() {
        return saldo;
    }
    
    public synchronized void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w wplata");
        }
        saldo += kwota;
        notify();
    }

    public synchronized void wyplata(int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w wyplata");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Brak środków");
        }
        saldo -= kwota;
    }
    
    // Ta wersja w przypadku braku pieniędzy będzie oczekiwać, a nie będzie wyrzucać wyjątku.
    public synchronized void wyplataCzekaj(int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w wyplata");
        }
        try {
			while(kwota > saldo) {
				wait();
			}
			saldo -= kwota;
			notify();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
    }
    
    public void przelew(Konto kontoDocelowe, int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w przelew");
        }
        synchronized(this) {
	        if(kwota > this.saldo) {
	            throw new BrakSrodkow("Brak środków do przelewu");
	        }
        	this.saldo -= kwota;
        }
        synchronized(kontoDocelowe) {
        	kontoDocelowe.saldo += kwota;
        	kontoDocelowe.notify();
        }
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo " + saldo + ", wł. " + wlasciciel;
    }

}
