package obiekty;

public class Konto {
    private final int numer;
    private int saldo;
    private Osoba wlasciciel;
    
    public Konto(int numer, int saldo, Osoba wlasciciel) {
        if(saldo < 0) {
            throw new IllegalArgumentException("Ujemna kwota w konstruktorze");
        }
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    // Tylko dla pole wlasciciel pozwalamy na zmianę wartości.
    // Nie tworzymy setterów dla pól:
    // - numer - ponieważ numer nie będzie się zmieniać (w konkretnym obiekcie)
    //            dodatkowym podkreśleniem tego faktu i zabezpieczeniem przed własnymi błędami
    //            jest dopisanie final do pola numer
    // - saldo - ponieważ zmiana salda ma być możliwa tylko za pośrednictwem "metod biznesowych" wpłata, wypłata, przelew

    public Osoba getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(Osoba wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public int getSaldo() {
        return saldo;
    }
    
    public void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w wplata");
        }
        saldo += kwota;
    }

    public void wyplata(int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w wyplata");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Brak środków");
        }
        // Jeśli nie było powodu, aby przerwać, to wykonujemy zleconą operację.
        saldo -= kwota;
    }
    
    public void przelew(Konto cel, int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Ujemna kwota w przelew");
        }
        if(kwota > this.saldo) {
            throw new BrakSrodkow("Brak środków do przelewu");
        }
        this.saldo -= kwota;
        cel.saldo += kwota;
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo " + saldo + ", wł. " + wlasciciel;
    }

}
