package sprzedaz.wydajnosc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MaszynaWczytujaca {
	private final Map<String, LocalDate> pulaDat = new ConcurrentHashMap<>();
	private final Map<String, BigDecimal> pulaCen = new ConcurrentHashMap<>();
	
	public Transakcja wczytajJedenRekord(String linia) {
		String[] pola = linia.split(",");
		int sztuk = Integer.parseInt(pola[6]);
		
		LocalDate data = pulaDat.computeIfAbsent(pola[0], LocalDate::parse);
		BigDecimal cena = pulaCen.computeIfAbsent(pola[5], BigDecimal::new);

		String miasto = pola[1].intern();
		String sklep = pola[2].intern();
		String kategoria = pola[3].intern();
		String towar = pola[4].intern();

		return new Transakcja(data, miasto, sklep, kategoria, towar, cena, sztuk);
	}

	public static List<Transakcja> wczytajCalyPlik(File plik) throws IOException {
		MaszynaWczytujaca maszynaWczytujaca = new MaszynaWczytujaca();
		
		List<Transakcja> lista = new ArrayList<>();
		try(BufferedReader reader = Files.newBufferedReader(plik.toPath())) {
			String linia;
			while ((linia = reader.readLine()) != null) {
				Transakcja transakcja = maszynaWczytujaca.wczytajJedenRekord(linia);
				lista.add(transakcja);
			}
		}
		return lista;
	}
	
}
