package sprzedaz.strumieniowo;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class Transakcja {
    private LocalDate data;
    private String miasto;
    private String sklep;
    private String kategoria;
    private String towar;
    private BigDecimal cena;
    private int sztuk;

    public Transakcja(LocalDate data, String miasto, String sklep, String kategoria, String towar, BigDecimal cena,    int sztuk) {
        this.data = data;
        this.miasto = miasto;
        this.sklep = sklep;
        this.kategoria = kategoria;
        this.towar = towar;
        this.cena = cena;
        this.sztuk = sztuk;
    }

    public LocalDate getData() {
        return data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public String getMiasto() {
        return miasto;
    }

    public void setMiasto(String miasto) {
        this.miasto = miasto;
    }

    public String getSklep() {
        return sklep;
    }

    public void setSklep(String sklep) {
        this.sklep = sklep;
    }

    public String getKategoria() {
        return kategoria;
    }

    public void setKategoria(String kategoria) {
        this.kategoria = kategoria;
    }

    public String getTowar() {
        return towar;
    }

    public void setTowar(String towar) {
        this.towar = towar;
    }

    public BigDecimal getCena() {
        return cena;
    }

    public void setCena(BigDecimal cena) {
        this.cena = cena;
    }

    public int getSztuk() {
        return sztuk;
    }

    public void setSztuk(int sztuk) {
        this.sztuk = sztuk;
    }

    public BigDecimal getWartosc() {
        // return this.getCena().multiply(BigDecimal.valueOf(this.getSztuk()));
        return cena.multiply(BigDecimal.valueOf(sztuk));
    }

    public double getWartoscDouble() {
        return this.getWartosc().doubleValue();
    }

    @Override
    public String toString() {
        return "Transakcja [data=" + data + ", miasto=" + miasto + ", sklep=" + sklep + ", kategoria=" + kategoria
                + ", towar=" + towar + ", cena=" + cena + ", sztuk=" + sztuk + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(cena, data, kategoria, miasto, sklep, sztuk, towar);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Transakcja other = (Transakcja) obj;
        return Objects.equals(cena, other.cena) && Objects.equals(data, other.data)
                && Objects.equals(kategoria, other.kategoria) && Objects.equals(miasto, other.miasto)
                && Objects.equals(sklep, other.sklep) && sztuk == other.sztuk && Objects.equals(towar, other.towar);
    }

}


