package sprzedaz.strumieniowo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class P4_Grupowanie_v1 {

    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");
        
        Map<String, List<Transakcja>> grupy = transakcje.stream()
                .collect(Collectors.groupingBy(Transakcja::getMiasto));
        
        // dla klucza, którym jest miasto, wartością jest lista transakcji z tego miasta
        // zapiszmy transakcje z każdej grupy w oddzielnym pliku
        
        grupy.forEach((miasto, lista) -> {
            System.out.println("Zapisuję plik dla miasta " + miasto);
            ObslugaCSV.zapisz(lista, "sprzedaz_" + miasto.toLowerCase() + ".csv");
        });
    }

}
