package sprzedaz.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class P4_Grupowanie_v4 {
    
    // w tej wersji używam operacji merge, która pojawiła się w Java 8
    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");

        Map<String, Double> sumy = new HashMap<>();
        for(Transakcja transakcja : transakcje) {
            sumy.merge(transakcja.getMiasto(), transakcja.getWartoscDouble(), Double::sum);
            // jeśli wpisu pod tym kluczem jeszcze nie ma → wstawia podaną wartość
            // jeśli wpis już jest → aktualizuje wartość za pomocą wskzanej funkcji (tutj add czyli dodawanie) i podanej wartości
        }
        
        for(Map.Entry<String, Double> entry : sumy.entrySet()) {
            System.out.printf("| %-10s | %11.2f |\n", entry.getKey(), entry.getValue());            
        }
    }

}
