package xml.przyklady_sax;

import javax.xml.XMLConstants;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

import xml.pomoce.MojBrutalnyErrorHandler;

public class SredniaCena_SAX_ZaPomocaFiltra {
	public static void main(String[] args) {
		if(args.length < 2) {
			System.out.println("Za malo argumentow. Podaj nazwe pliku i idKategorii.");
			return;
		}
		
		try {
			SredniaCenaHandler_Porzadniej mojHandler = new SredniaCenaHandler_Porzadniej();
			MojBrutalnyErrorHandler eh = new MojBrutalnyErrorHandler();
			
			SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Schema schema = sf.newSchema(new StreamSource("sklep.xsd"));

			SAXParserFactory spf = SAXParserFactory.newInstance();
			spf.setSchema(schema);
			SAXParser parser = spf.newSAXParser();
			XMLReader reader = parser.getXMLReader();
			
			FiltrKategorii filtr = new FiltrKategorii(args[1]);
			filtr.setParent(reader);  // to wewnetrznie spowoduje wywolanie reader.setContentHandler(filtr)
			filtr.setContentHandler(mojHandler);
			filtr.setErrorHandler(eh); // mniej istotne
			filtr.parse(args[0]);  // to wewnetrznie spowoduje wywolanie reader.parse
			System.out.println(mojHandler.wypisz());
			
		} catch (SAXException e) {
			System.out.println("Blad parsowania.");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
