package waluty;

import java.time.LocalDate;

public abstract class Pobieranie {

    protected static final String ADRES_BAZOWY = "https://api.nbp.pl/api/exchangerates/tables";

    public abstract TabelaWalut pobierzBiezaceKursy() throws BladAplikacji;

    public abstract TabelaWalut pobierzArchiwalneKursy(String data) throws BladAplikacji;
    
    // Jeśli jakaś część implementacji jest wpólna dla wszystkich podklas,
    // to można umieścić ja w klasie abstrakcyjnej
    public TabelaWalut pobierzArchiwalneKursy(LocalDate data) throws BladAplikacji {
        return pobierzArchiwalneKursy(data.toString());
    }
    
    // fabryka nowych obiektów
    public static Pobieranie utworz(String format) {
        return switch(format.toUpperCase()) {
            case "XML" -> new PobieranieXML();
            case "JSON" -> new PobieranieJSON();
            default -> throw new IllegalArgumentException("Nieznany format " + format);
        };
    }

}
