package swing.rysowanie;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.Timer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JToggleButton;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ThreadLocalRandom;

public class OknkoZPilka {

	private static final Font FONT_GUZIKOW = new Font("Dialog", Font.BOLD, 20);
	private JFrame frame;
	private Timer spadanie;
	private PanelGraficzny panelGraficzny;
	private JToggleButton tglbtnSpadaj;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					OknkoZPilka window = new OknkoZPilka();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public OknkoZPilka() {
		initialize();
		mojeUstawienia();
	}
	
	private void mojeUstawienia() {
		spadanie = new Timer(500, new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(tglbtnSpadaj.isSelected()) {
					panelGraficzny.wDol();
				}
			}
		});
		spadanie.start();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setBounds(100, 100, 1075, 724);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		panelGraficzny = new PanelGraficzny();
		panelGraficzny.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent ev) {
				
				switch(ev.getButton()) {
				case MouseEvent.BUTTON1:
					panelGraficzny.ustawPolozenie(ev.getX(), ev.getY());
					break;
				case MouseEvent.BUTTON3:
					panelGraficzny.zmienKolor();
					break;
				}
			}
		});
		
// TODO :)
//		panelGraficzny.addKeyListener(new KeyAdapter() {
//			@Override
//			public void keyPressed(KeyEvent evt) {
//				switch(evt.getKeyChar()) {
//				case 'a': panelGraficzny.wLewo(); break;
//				case 'd': panelGraficzny.wPrawo(); break;
//				}
//			}
//		});
		panelGraficzny.setBackground(Color.WHITE);
		
		JPanel panelGuzikow = new JPanel();
		GroupLayout groupLayout = new GroupLayout(frame.getContentPane());
		groupLayout.setHorizontalGroup(
			groupLayout.createParallelGroup(Alignment.LEADING)
				.addGroup(Alignment.TRAILING, groupLayout.createSequentialGroup()
					.addContainerGap()
					.addGroup(groupLayout.createParallelGroup(Alignment.TRAILING)
						.addComponent(panelGraficzny, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 1043, Short.MAX_VALUE)
						.addComponent(panelGuzikow, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 1043, Short.MAX_VALUE))
					.addContainerGap())
		);
		groupLayout.setVerticalGroup(
			groupLayout.createParallelGroup(Alignment.LEADING)
				.addGroup(Alignment.TRAILING, groupLayout.createSequentialGroup()
					.addContainerGap()
					.addComponent(panelGraficzny, GroupLayout.DEFAULT_SIZE, 545, Short.MAX_VALUE)
					.addGap(18)
					.addComponent(panelGuzikow, GroupLayout.PREFERRED_SIZE, 104, GroupLayout.PREFERRED_SIZE)
					.addContainerGap())
		);
		
		JButton btnLewo = new JButton("LEWO");
		btnLewo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panelGraficzny.wLewo();
			}
		});
		btnLewo.setFont(FONT_GUZIKOW);
		
		JButton btnPrawo = new JButton("PRAWO");
		btnPrawo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panelGraficzny.wPrawo();
				// panelGraficzny.repaint();
			}
		});
		btnPrawo.setFont(FONT_GUZIKOW);
		
		tglbtnSpadaj = new JToggleButton("Spadaj");
		tglbtnSpadaj.setFont(FONT_GUZIKOW);
		GroupLayout gl_panelGuzikow = new GroupLayout(panelGuzikow);
		gl_panelGuzikow.setHorizontalGroup(
			gl_panelGuzikow.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_panelGuzikow.createSequentialGroup()
					.addContainerGap()
					.addComponent(btnLewo, GroupLayout.PREFERRED_SIZE, 111, GroupLayout.PREFERRED_SIZE)
					.addGap(18)
					.addComponent(btnPrawo, GroupLayout.PREFERRED_SIZE, 124, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(tglbtnSpadaj, GroupLayout.PREFERRED_SIZE, 118, GroupLayout.PREFERRED_SIZE)
					.addContainerGap(648, Short.MAX_VALUE))
		);
		gl_panelGuzikow.setVerticalGroup(
			gl_panelGuzikow.createParallelGroup(Alignment.LEADING)
				.addGroup(Alignment.TRAILING, gl_panelGuzikow.createSequentialGroup()
					.addContainerGap()
					.addGroup(gl_panelGuzikow.createParallelGroup(Alignment.TRAILING)
						.addComponent(tglbtnSpadaj, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)
						.addGroup(Alignment.LEADING, gl_panelGuzikow.createParallelGroup(Alignment.BASELINE)
							.addComponent(btnLewo, GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)
							.addComponent(btnPrawo, GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)))
					.addContainerGap())
		);
		panelGuzikow.setLayout(gl_panelGuzikow);
		frame.getContentPane().setLayout(groupLayout);
	}
	
	private static 
	class PanelGraficzny extends JPanel {
		private static final int SREDNICA = 40;
		// położenie i kolor "piłki"
		private int x, y;
		private Color kolor = Color.RED;
		private int numer = 0;
		
		@Override
		protected void paintComponent(Graphics g) {
			super.paintComponent(g);
			
			numer++;
			g.drawString(""+numer, 100, 100);
			
			g.setColor(kolor);
			g.fillOval(x, y, SREDNICA, SREDNICA);
			
//			try {
//				BufferedImage img = ImageIO.read(new File("obrazek.jpg"));
//				g.drawImage(img, ...)
//				
//			} catch (IOException e) {
//				e.printStackTrace();
//			}
			
		}
		
		public void wPrawo() {
			x += SREDNICA;
			if(x + SREDNICA > this.getWidth()) {
				x = this.getWidth() - SREDNICA;
			}
			repaint();
		}

		public void wLewo() {
			x -= SREDNICA;
			if(x < 0) {
				x = 0;
			}
			repaint();
		}

		public void wDol() {
			y += SREDNICA;
			if(y + SREDNICA > this.getHeight()) {
				y = this.getHeight() - SREDNICA;
			}
			repaint();
		}
		
		public void ustawPolozenie(int x, int y) {
			this.x = x - SREDNICA/2;
			this.y = y - SREDNICA/2;
			repaint();
		}
		
		public void zmienKolor() {
			int nowyKolor = ThreadLocalRandom.current().nextInt(0x1000000);
			this.kolor = new Color(nowyKolor);
			this.repaint();
		}
	}
}
