package gotowe.p30_lambdy.html;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GeneratorStron {
	
	public static String utworzStrone(String tytul, HTMLable... elementy) {
		String polaczone = Stream.of(elementy)
				.map(HTMLable::toHTML)
				.collect(Collectors.joining("\n"));
		
		return String.format("""
				<!DOCTYPE html>
				<html>
				<head>
					<meta charset="UTF-8">
					<title>%s</title>
				</head>
				<body>
					<h1>%s</h1>
					%s
				</body>
				</html>
				""", tytul, tytul, polaczone);
	}
	
	public static void zapiszStrone(File plik, String tytul, HTMLable... elementy) throws IOException {
		String html = utworzStrone(tytul, elementy);
		Files.writeString(plik.toPath(), html, Charset.forName("UTF-8"));
	}

	public static void main(String[] args) {
		Adres adres = new Adres("Jasna", "14/16a", "01-234", "Warszawa");
		Osoba ala = new Osoba("Ala", "Kowalska", adres);
		Osoba ola = new Osoba("Ola", "Malinowska", adres);

		// do metody zapiszStrone mogę przekazać dowolne obiekty zgodne z interfejsem HTMLable,
		// ale gdybym potrzebował dorzucić dowlny fragment HTML mogę też przekazać wyrażenie lambda, które w wyniku daje HTMLa
		// dzięki temu, że interfejs HTMLable jest "interfejsem funkcyjnym", czyli ma tylko jedną metodę do zaimplementowania
		try {
			ola.showHTML();
			adres.showHTML();
			
			JFileChooser chooser = new JFileChooser();
			chooser.setFileFilter(new FileNameExtensionFilter("Pliki HTML", "html", "htm"));
			int coSieStalo =  chooser.showSaveDialog(null);
			if(coSieStalo == JFileChooser.APPROVE_OPTION) {
				zapiszStrone(chooser.getSelectedFile(), "Pracownicy ALX",
						ala, ola, () -> "<h2>Adres firmy</h2>", adres);
				JOptionPane.showMessageDialog(null, "Plik zpaisany");
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
