package gotowe.p06_funkcje.przyklady;

public class JednostkiMiary {
    static {
        System.out.println("ładowana jest klasa JednostkiMiary");
    }

    /** Funkcja przelicza podaną liczbę mil na kilometry. */
    public static double mile_na_km(double mile) {
        return mile * 1.609344;
    }

    // Napisz w tym miejscu funkcję km_na_mile , która przelicza w drugą stronę, a do main dopisz 2-3 przykładowe wywołania
    public static double km_na_mile(double km) {
        return km / 1.609344;
    }

    // Napisz funkcje far_na_cel i cel_na_far
    // które przeliczają temperaturę w stopniach Fahrenheita na stopnie Celsjusza i odwrotnie
    // https://pl.wikipedia.org/wiki/Skala_Fahrenheita

    public static double far_na_cel(double far) {
        // źle: return 5/9 * (far - 32);
        // kilka poprawnych rozwiązań:
        return 5. / 9. * (far - 32.);
        // return (far - 32) * 5/9;
        // return (far - 32) / 1.8;
    }

    public static double cel_na_far(double cel) {
        //źle: return 32 + 9/5 * cel;
        // poprawne:
        // return 32. + 9./5. * cel;
        // return cel * 9 / 5 + 32;
        return 1.8 * cel + 32;
    }

    public static void main(String[] args) {
        // Ten program nie będzie interaktywny, nie będzie pytać użytkownika o dane.
        // Tutaj tylko przetestujemy funkcje na kilku wartościach.

        System.out.println("100 mil = " + mile_na_km(100) + " km");
        System.out.println("500 mil = " + mile_na_km(500) + " km");
        System.out.println();

        System.out.println("100 km = " + km_na_mile(100) + " mil");
        System.out.println("160 km = " + km_na_mile(160) + " mil");
        System.out.println();

        System.out.println("0 F = " + far_na_cel(0) + " C");
        System.out.println("100 F = " + far_na_cel(100) + " C"); // 37.7
        System.out.println();

        System.out.println("0 C = " + cel_na_far(0) + " F");
        System.out.println("37 C = " + cel_na_far(37) + " F");
        System.out.println("100 C = " + cel_na_far(100) + " F");
    }

}
