package gotowe.p06_funkcje.importowanie;

/* W tej wersji programu nie ma żadnych importów, a wszystkie odwołania do klasy Geometria
 * oraz standardowych klas JOptionPane i Random są poprzedzone nazwą pakietu.
 * 
 * W języku Java ZAWSZE da się napisać program bez użycia import.
 */

public class Importowanie0 {
    public static void main(String[] args) {
        @SuppressWarnings("resource")
        java.util.Scanner scanner = new java.util.Scanner(System.in);

        petla:
        while(true)
          try {
            System.out.println("\nWybierz figurę:");
            System.out.println("  K  - kwadrat");
            System.out.println("  O  - koło");
            System.out.println("  P  - prostokąt");
            System.out.println("  T  - trójkąt");
            System.out.println("  KM - przelicz kilometry na mile");
            System.out.println("  MK - przelicz mile na kilometry");
            System.out.println("  CF - przelicz °C na °F");
            System.out.println("  FC - przelicz °F na °C");
            System.out.println("  Q  - zakończ");
            String wybor = scanner.next().toUpperCase();
            switch(wybor) {
              case "Q" -> {
                // muszę użyć "etykiety", aby powiedzieć Javie, że przerywam pętlę while, a nie samego switcha
                break petla;
              }
              case "K" -> {
                System.out.print("Podaj długość boku kwadratu: ");
                double a = scanner.nextDouble();
                double pole = gotowe.p06_funkcje.przyklady.Geometria.poleKwadratu(a);
                double obwod = gotowe.p06_funkcje.przyklady.Geometria.obwodKwadratu(a);
                System.out.printf("Dla kwadratu o boku %.3f pole wynosi %.3f, a obwód %.3f\n", a, pole, obwod);
              }
              case "P" -> {
                System.out.print("Podaj długość pierwszego boku prostokąta: ");
                double a = scanner.nextDouble();
                System.out.print("Podaj długość drugiego boku prostokąta: ");
                double b = scanner.nextDouble();
                double pole = gotowe.p06_funkcje.przyklady.Geometria.poleProstokata(a, b);
                double obwod = gotowe.p06_funkcje.przyklady.Geometria.obwodProstokata(a, b);
                System.out.printf("Dla prostokąta o bokach %.3f i %.3f pole wynosi %.3f, a obwód %.3f\n", a, b, pole, obwod);
              }
              case "T" -> {
                System.out.print("Podaj długość pierwszego boku trójkąta: ");
                double a = scanner.nextDouble();
                System.out.print("Podaj długość drugiego boku trójkąta: ");
                double b = scanner.nextDouble();
                System.out.print("Podaj długość trzeciego boku trójkąta: ");
                double c = scanner.nextDouble();
                double pole = gotowe.p06_funkcje.przyklady.Geometria.poleTrojkata(a, b, c);
                double obwod = gotowe.p06_funkcje.przyklady.Geometria.obwodTrojkata(a, b, c);
                System.out.printf("Dla prostokąta o bokach %.3f i %.3f pole wynosi %.3f, a obwód %.3f\n", a, b, pole, obwod);
              }
              case "O" -> {
                System.out.print("Podaj promień koła: ");
                double r = scanner.nextDouble();
                double pole = gotowe.p06_funkcje.przyklady.Geometria.poleKola(r);
                double obwod = gotowe.p06_funkcje.przyklady.Geometria.obwodKola(r);
                System.out.printf("Dla koła o promieniu %.3f pole wynosi %.3f, a obwód %.3f\n", r, pole, obwod);
              }
              case "KM" -> {
                System.out.print("Podaj odległość w kilometrach: ");
                double km = scanner.nextDouble();
                double wynik = gotowe.p06_funkcje.przyklady.JednostkiMiary.km_na_mile(km);
                System.out.printf("%.3f km = %.3f mil\n", km, wynik);
              }
              case "MK" -> {
                System.out.print("Podaj odległość w milach: ");
                double mile = scanner.nextDouble();
                double wynik = gotowe.p06_funkcje.przyklady.JednostkiMiary.mile_na_km(mile);
                System.out.printf("%.3f mil = %.3f km\n", mile, wynik);
              }
              case "FC" -> {
                System.out.print("Podaj temperaturę w Fahrenheitach: ");
                double f = scanner.nextDouble();
                double wynik = gotowe.p06_funkcje.przyklady.JednostkiMiary.far_na_cel(f);
                System.out.printf("%.3f °F = %.3f °C\n", f, wynik);
              }
              case "CF" -> {
                System.out.print("Podaj temperaturę w Celsjuszach: ");
                double c = scanner.nextDouble();
                double wynik = gotowe.p06_funkcje.przyklady.JednostkiMiary.cel_na_far(c);
                System.out.printf("%.3f °C = %.3f °F\n", c, wynik);
              }
              default -> {
                System.out.println("Nieznane polecenie " + wybor);
              }
            }
          } catch(Exception e) {
            System.out.println("Błąd: " + e);
        }
    }
}
