package gotowe.p02_zmienne;

public class C_Inicjalizacja {
    // zmienne statyczne - inicjowane domyślnie na 0, false lub null
    static int st;

    // zmienne instancyjne - inicjowane domyślnie na 0, false lub null
    int inst;

    public static void main(String[] args) {
        // zmienne lokalne - nie są automatyczne inicjowane
        int lokalna;

        System.out.println(st); // 0
        //NK System.out.println(inst); // próba dostępu do zmiennej niestatycznej w kontekście statycznym

        C_Inicjalizacja obiekt = new C_Inicjalizacja();
        System.out.println(obiekt.inst); // 0

        // błąd kompilacji - aby odczytać zmienną lokalną, musi zostać wcześniej zainicjalizowana (w taki sposób, żeby kompilator miał pewność)
        //NK System.out.println(lokalna);

        if(st >= 0) {
            lokalna = 13;
            System.out.println(lokalna); // OK - tu zmienna "na pewno jest zainicjowana"
        }
        //NK System.out.println(lokalna); // tutaj wg kompilatora "może być niezainicjowana"

        if(st >= 0) {
            lokalna = 10;
        } else {
            lokalna = 20;
        }
        System.out.println(lokalna); // OK
    }

}
