package bazy_danych.podstawy;

import javax.swing.*;
import java.math.BigDecimal;
import java.sql.*;

// Zadanie: niech program wypisuje tylko tych pracowników, którzy mają podane job_id
// Wada tego rozwiązania: NISKA WYDAJNOŚĆ
// Serwer odczytuje wszystkie rekordy z dysku
// wszystkie rekordy są przesyłanie przez sieć
// wszystkie rekordy są odbieranie i przeglądane przez program w Javie.
public class PracownicyWedlugJob1 {
    public static void main(String[] args) {
        try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "alx", "abc123")) {
            String szukanyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska", "IT_PROG");

            try(PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees")) {
                try(ResultSet rs = stmt.executeQuery()) {
                    while(rs.next()) {
                        String job = rs.getString("job_id");
                        if(job.equals(szukanyJob)) {
                            String imie = rs.getString("first_name");
                            String nazwisko = rs.getString("last_name");
                            BigDecimal pensja = rs.getBigDecimal("salary");
                            System.out.printf("%s %s (%s) zarabia %s%n", imie, nazwisko, job, pensja);
                        }
                    }
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
