package apacz;

import org.apache.commons.lang3.StringUtils;

public class PrzykladyString {

	public static void main(String[] args) {
		String[] a = {"Ala", "Ola", "", "Ewelina", " ", null};
		String[] b = {"Ala", "Ola", "Ewelina"};
		String[] c = {"     ", "", null};

		// Pisząc w "zwykłej Javie" gdy chcemy wypisać z tablicy a wszystkie napisy, które nie są puste
		// trzeba uwzględnić możliwość, że wartość jest nullem
		int ile = 0;
		for (String s : a) {
			if(s != null && !s.isBlank()) {
				System.out.println(s);
				ile++;
			}
		}
		System.out.println("tyle: " + ile);
		System.out.println();
		// biblioteka Apache Commons Lang oferuje gotowe metody umieszczona w klasach narzędziowych
		// np. dla stringów mamy klasę StringUtils.
		
		ile = 0;
		for (String s : a) {
			if(StringUtils.isNotBlank(s)) {
				System.out.println(s);
				ile++;
			}
		}
		System.out.println("tyle: " + ile);
		System.out.println();
		
		// operacje dla całych tablic (lub wartości podawanych po przecinku)
		if(StringUtils.isNoneBlank(a)) {
			System.out.println("W a są same dobre napisy");
		} else {
			System.out.println("W a są też pustaki");			
		}

		if(StringUtils.isNoneBlank(b)) {
			System.out.println("W b są same dobre napisy");
		} else {
			System.out.println("W b są też pustaki");			
		}

		if(StringUtils.isAllBlank(c)) {
			System.out.println("ccc");
		}
		
	}

}
