package gotowe.p03_instrukcje.a_if;

import java.util.Random;

public class A_TeoriaIf {

    public static void main(String[] args) {
        Random random = new Random();
        int x = random.nextInt(100); // liczba od 0 do 99 włącznie
        int y = random.nextInt(100);

        System.out.println("Wylosowane liczby:");
        System.out.printf("x = %d , y = %d\n", x, y);

        // Wzorcowa wersja if:
        // if(WARUNEK) { INSTRUKCJE1 } else { INSTRUKCJE2 }
        // Gdy WARUNEK jest prawdą, wykonają się INSTRUKCJE1, a jeśli nieprawdą to INSTRUKCJE2
        if(x % 2 == 0) {
            System.out.println("x jest parzysty");
            System.out.println("Ala ma kota");
        } else {
            System.out.println("x jest nieparzysty");
            System.out.println("Ola ma psa");
        }
        System.out.println("a kuku");
        System.out.println();

        // Jeśli za ifem lub elsem do wykonania jest tylko jedna instrukcja, to można pominąć nawiasy klamrowe.
        if(x >= 50)
            System.out.println(">= 50");
        else
            System.out.println("<  50");
        // Używajmy tego jednak z umiarem, tylko w bardzo prostych przypadkach, np. break, throw, return...
        // W większości przypadków zalecane jest wzięcie wykonywanego kodu w {nawiasy klamrowe},
        // gdyż łatwiej dokonać późniejszych zmian, np. dodać kolejną linię itp...

        /* Za instrukcją strukturalną (if, while, for...) w praktyce nigdy nie stawia się średnika
        if(x == y); {
            System.out.println("Obie liczby są równe!");
        }
           Powyższy kod zawsze wyświetliłby podany napis, bo struktiura jest taka:
           "jeśli x == y, nie rób nic; a później ZAWSZE wypisuj ten tekst"
        */

        // Można użyć samego if, bez else:

        if(x + y >= 100) {
            System.out.println("suma x i y jest trzycyfrowa");
        }

        // ify (i inne instrukcje blokowe) można zagnieżdżać. Tutaj tym bardziej zalecamy pisanie nawiasów {}

        if(x % 2 == 0) {
            if(y % 2 == 0) {
                System.out.println("obie liczby są parzyste");
            } else {
                System.out.println("x parzysty, y nieparzysty");
            }
        } else {
            if(y % 2 == 0) {
                System.out.println("x nieparzysty, y parzysty");
            } else {
                System.out.println("obie liczby nieparzyste");
            }
        }
        System.out.println();

        // Jeśli rozpatrywanych sytuacji jest więcej niż 2, to typowym sposobem zapisu jest ciąg
        // if - else if - ... - else
        if(x > y) {
            System.out.println("x > y");
        } else if(x < y) {
            System.out.println("x < y");
        } else {
            System.out.println("x = y");
        }

        // W Javie nie ma automatycznej konwersji liczb (ani innych rzeczy) na boolean
        //  if(liczba) {
        //      System.out.println("Nie zero");
        //  }
        //
        //  if(liczba = 0) {
        //      System.out.println("Nie zero");
        //  }

        // Warunkiem najczęściej jest porównanie, ale może też być wywołanie metody typu boolean
        String str = "Ala ma kota";
        if(str.isEmpty()) {
            System.out.println("puste");
        }

        // może też być bezpośrednie użycie zmiennej typu boolean
        boolean logika = x > 10 && y % 3 == 0;
        if(logika) {
            System.out.println("Dziwny warunek jest prawdą");
        } else {
            System.out.println("Nieprawda");
        }

        System.out.println("Koniec programu");
    }

}
