package przyklady_plikowe;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class McDonalds2 {

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);

        // opisuję napis taki jak (123 g)
        // dodatkowe nawiasy otaczają ciąg cyfr - w ten sposób definiuję "grupę" nr 1, do której będę odwoływał się w kodzie
        Pattern pattern = Pattern.compile("\\((\\d+) g\\)");

        try(BufferedReader input = new BufferedReader(new FileReader("mcdonalds.csv"))) {
            String linia = input.readLine();
            // pierwsza linia zawiera nazwy kolumn
            String[] naglowki = linia.split(",");
            // dalsze linie zawierają dane - czytamy dopóki nie dojdziemy na koniec pliku
            while((linia = input.readLine()) != null) {
                String[] dane = linia.split(",");
                Matcher matcher = pattern.matcher(dane[2]);
                if(matcher.find()) {
                    double kalorie = Double.parseDouble(dane[3]);
                    int gramy = Integer.parseInt(matcher.group(1));
                    double nasycenie = kalorie / gramy;
                    System.out.printf("Produkt '%s' z kategorii %s ma %.1f kalorii przy rozmiarze %d → nasycenie %.3f%n",
                            dane[1], dane[0], kalorie, gramy, nasycenie);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
