package gotowe.p40_io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Kopiuj2 {
	private static final int ROZMIAR = 4096;
	
	public static void kopiuj(String wejscie, String wyjscie) {
		// try-with-resources - dostepne od Javy 7
		// Closable
		try(FileInputStream is = new FileInputStream(wejscie);
			FileOutputStream os = new FileOutputStream(wyjscie)) {
			
			 byte[] bufor = new byte[ROZMIAR];
			 //Arrays.fill(bufor, (byte)'x');
			 int licznik = 0;
			 int ile;
			 while((ile = is.read(bufor)) != -1) {
				 System.out.println("Wczytałem "+ile+" bajtów");
				 os.write(bufor, 0, ile);
				 licznik += ile;
				 // os.flush(); - popchanie danych do pliku
			 }
			 
			 System.out.println("licznik = " + licznik);
		} catch (FileNotFoundException e) {
			System.out.println("Plik nie znaleziony "+e.getMessage());
		} catch (IOException e) {
			System.out.println("Błąd wej/wyj "+e.getMessage());
		}
	}
	

	public static void main(String[] args) {
		long start = System.currentTimeMillis();
		kopiuj("pliki/pan_tadeusz.txt", "kopia2.txt");
		long koniec = System.currentTimeMillis();
		
		System.out.println("Koniec kopiowania, czas " + (koniec - start));
	}
}
