package gotowe.p40_io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class InputStream_DodatkoweMetody {

	public static void main(String[] args) {
		try {
			FileInputStream in = new FileInputStream("plik.txt");
			//FileInputStream in = new FileInputStream("pan-tadeusz.txt");
			
			// Zwykły FileInputStream nie wspiera markowania
			System.out.println("markSupported: " + in.markSupported());
			
			int available = in.available();
			System.out.println("available: " + available);
			
			long skip = in.skip(12);
			System.out.println("skip: " + skip);
			System.out.println("available: " + in.available());
			
			byte[] bajty = new byte[100];
			int ile = in.read(bajty);
			System.out.println("read: " + ile);
			
			String tekst = new String(bajty, 0, ile);
			System.out.println("tekst: " + tekst);
			System.out.println("available: " + in.available());
						
			in.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
