package emps.v3_funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

// W tej wersji dla każdej grupy od razu obliczymy funkcję agregującą "average".
// Takie znaczenie słowa "grupowanie", jak w SQL.
public class Grupowanie8 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Double> grupy = emps.stream()
				.collect(Collectors.groupingBy(
						Employee::getJobTitle,
						Collectors.averagingInt(Employee::getSalary)));
		
		grupy.forEach((job, srednia) -> {
			System.out.printf("%-32s → %8.2f%n", job, srednia);
		});
	}

}
