package xml.rooms;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;

import xml.pomoce.Args;

public class CountSeats_SAX_JAXP {
	public static void main(String[] args) {
		args = Args.argsOrDefault(args, "rooms.xml");
		String input = args[0];
		try {
			CountSeats_SAX_JAXP program = new CountSeats_SAX_JAXP();
			int result = program.countSeats(input);
			System.out.println("Result: " + result);
		} catch (Exception e) {
			System.out.println("Exception! " + e.getMessage());
			e.printStackTrace();
		}
	}

	public int countSeats(String fileName) throws ParserConfigurationException, SAXException, IOException  {
		System.out.println("Starting with file " + fileName);
		CSHandler_JAXP handler = new CSHandler_JAXP();
		SAXParserFactory spf = SAXParserFactory.newInstance();
		SAXParser parser = spf.newSAXParser();
		parser.parse(fileName, handler);
		return handler.getSum();
	}
}
