package xml.przyklady_sax;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class StatystykiSAX {
	public static void main(String[] args) {
		if(args.length < 1) {
			System.out.println("Za malo argumentow. Podaj nazwe pliku.");
			return;
		}
		
		try {
			StatystykiHandler mojHandler = new StatystykiHandler();
			
			/* Inny sposob tworzenia parsera SAX:
			SAXParserFactory sf = SAXParserFactory.newInstance();
			SAXParser parser = sf.newSAXParser();
			parser.parse(args[0], mojHandler);
			*/
			
			XMLReader reader = XMLReaderFactory.createXMLReader();
			reader.setContentHandler(mojHandler);
			reader.parse(args[0]);
			System.out.println(mojHandler.wypisz());
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

}
