package waluty;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Waluta {
	private final String code;
	private final String currency;
	private final BigDecimal mid;
	
	public Waluta(String code, String currency, BigDecimal mid) {
		this.code = code;
		this.currency = currency;
		this.mid = mid;
	}
	
	public String getCode() {
		return code;
	}

	public String getCurrency() {
		return currency;
	}

	public BigDecimal getMid() {
		return mid;
	}

	@Override
	public String toString() {
		return code + " (" + currency + "): " + mid;
	}
	
	public BigDecimal przeliczNaZlote(BigDecimal kwota) {
		return kwota.multiply(mid).setScale(2, RoundingMode.HALF_EVEN);
	}
	
	public BigDecimal przeliczNaWalute(BigDecimal kwota) {
		return kwota.divide(mid, 2, RoundingMode.HALF_EVEN);
	}

}
