package gotowe.p30_lambdy.html;

public class Osoba implements HTMLable {
	private String imie, nazwisko;
	private Adres adres;
	
	public Osoba(String imie, String nazwisko, Adres adres) {
		this.imie = imie;
		this.nazwisko = nazwisko;
		this.adres = adres;
	}

	public String getImie() {
		return imie;
	}

	public void setImie(String imie) {
		this.imie = imie;
	}

	public String getNazwisko() {
		return nazwisko;
	}

	public void setNazwisko(String nazwisko) {
		this.nazwisko = nazwisko;
	}

	public Adres getAdres() {
		return adres;
	}

	public void setAdres(Adres adres) {
		this.adres = adres;
	}
	
	public String toString() {
		return imie + " " + nazwisko + " " + ", adres: " + adres;
	}

	@Override
	public String toHTML() {
		String styl = "border: 2px solid blue; margin: 10px; padding:5px; background-color: #DDFFFF";
		return String.format("<div style='%s'><div>%s %s</div>\n%s</div>", styl, imie, nazwisko, adres.toHTML());
	}

}
