package gotowe.p25_kolekcje.zbieranie_danych;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import javax.print.attribute.standard.Sides;

public class P2_Lista_Sortowanie {
	// Listy:
	// - mogą zawierać duplikaty (tę wartość kilka razy),
	// - przechowują elementy na określonych pozycjach od 0 do size-1,
	//   za pomocą get(i) można odczytać, a za pomocą set(i, nowaWartosc) zmienić konkretny element listy
	
	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		// Gdy używamy listy nie musimy z wyprzedzeniem znać jej rozmiaru.
		// Do listy zawsze można dodać kolejny element na końcu (*)
		// (*) - realnymi ograniczeniami są: 1) rozmiar int, 2) dostępna pamięć
		
		List<String> lista = new ArrayList<>();
		
		while(true) {
			System.out.print("Podaj imię: ");
			// pusty String oznacza koniec
			String imie = scanner.nextLine();
			if(imie.isEmpty()) {
				break;
			}
			lista.add(imie);
		}
		
		System.out.println("Liczba odczytanych elementów: " + lista.size());
		System.out.println(lista);
		System.out.println("Sortowanie...");
		lista.sort(Collator.getInstance());
		System.out.println(lista);
		System.out.println();
		
		// Drugi etap: użytkownik podaje numer, a program odczytuje wartość z podanej pozycji.
		// -1 kończy
		while(true) {
			System.out.print("Podaj nr pozycji: ");
			int pozycja = scanner.nextInt();
			scanner.nextLine();
			if(pozycja == -1) {
				break;
			}
			try {
				String imie = lista.get(pozycja);
				System.out.println("Osoba nr " + pozycja + " to " + imie);
			} catch (Exception e) {
				System.out.println(e);
			}
		}
	}

}
