package gotowe.p12_dziedziczenie.a_podstawy;

// Przy definicjach w tym pakiecie nie ma zadeklarowanego poziomu widoczności (public/private).
// W tej sytuacji obowiązuje widoczność domyślna=pakietowa.
class Osoba {
    String imie, nazwisko;
    int wiek;

    static final int WIEK_PELNOLETNIOSCI = 18;

    Osoba() {
    }

    Osoba(String imie, String nazwisko, int wiek) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.wiek = wiek;
    }

    // Ta metoda zostanie nadpisana w podklasach
    void przedstawSie() {
        System.out.println("Nazywam się " + imie + " " + nazwisko + " i mam " + wiek + " lat.");
    }

    // Ta metoda nie będzie nadpisywana w podklasach. Można by do niej dopisać final.
    boolean pelnoletnia() {
        return wiek >= WIEK_PELNOLETNIOSCI;
    }

    void postarzejSie() {
        wiek += 1;
    }

    @Override
    public String toString() {
        return imie + " " + nazwisko + " (" + wiek + " lat)";
    }
}
