package xml.przyklady_sax;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Przefiltruj {

	public static void main(String[] args) {
		if(args.length < 3) {
			System.out.println("Za malo argumentow. Podaj nazwe pliku-wej, pliku-wyj i idKategorii.");
			return;
		}

		try {
			XMLReader reader = XMLReaderFactory.createXMLReader();
			
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			
			FiltrKategorii filtr = new FiltrKategorii(args[2]);
			filtr.setParent(reader);
			
			InputSource wejscie = new InputSource(args[0]);
			SAXSource src = new SAXSource(filtr, wejscie);
			StreamResult res = new StreamResult(args[1]);
			transformer.transform(src, res);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
