
package waluty;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;

public class PrzelicznikKonsolowy {
    private Scanner scanner;
    private Pobieranie pobieranie;
    
    public PrzelicznikKonsolowy() {
        scanner = new Scanner(System.in);
        scanner.useLocale(Locale.US);
    }
    
    public static void main(String[] args) {
        new PrzelicznikKonsolowy().run();
    }
    
    public void run() {
        System.out.println("Wybierz format danych: XML / JSON");
        String format = scanner.nextLine().trim().toUpperCase();
        switch(format) {
            case "XML" -> pobieranie = new PobieranieXML();
            case "", "JSON" -> pobieranie = new PobieranieJSON();
            default -> {
                System.out.println("Nieznany format, kończę program.");
                return;
            }
        }
        
        program: while(true) {
            System.out.println("\nWpisz datę w formacie YYYY-MM-DD lub naciśnij ENTER, aby pobrać bieżące kursy.");
            System.out.println("Możesz też wpisać Q , aby zakończyć program");
            String data = scanner.nextLine();
            try {
                TabelaWalut tabela;
                switch(data) {
                    case "q", "Q" -> {break program;}
                    case "" -> tabela = pobieranie.pobierzBiezaceKursy();
                    default -> tabela = pobieranie.pobierzArchiwalneKursy(data);
                }
                dzialajDlaWybranejTabeli(tabela);
            } catch(BladAplikacji e) {
                System.out.println("Wyjątek! " + e.getMessage());
            }
        }
        System.out.println("Koniec programu");
    }

    private void dzialajDlaWybranejTabeli(TabelaWalut tabela) {
        System.out.println(tabela);
        
        while(true) {
            System.out.println("\nPodaj kod waluty, lub Q aby zakończyć pracę z bieżącą tabelą");
            String code = scanner.nextLine().toUpperCase();
            if("Q".equals(code)) {
                break;
            }
            Optional<Waluta> found = tabela.findByCode(code);
            if(found.isEmpty()) {
                System.out.println("Nie ma waluty o kodzie " + code);
                continue;
            }
            dzialajDlaWybranejWaluty(found.get());
        }
    }

    private void dzialajDlaWybranejWaluty(Waluta waluta) {
        System.out.println("Wybrana waluta: " + waluta.getCode() + " (" + waluta.getCurrency() + ")" + ", kurs " + waluta.getMid());
        while(true) {
            System.out.println("\nPodaj kwotę do przeliczenia. 0 oznacza koniec:");
            BigDecimal kwota = scanner.nextBigDecimal();
            scanner.nextLine();
            if(kwota.compareTo(BigDecimal.ZERO) == 0) {
                break;
            }
            BigDecimal wynikWaluta = waluta.przeliczNaWalute(kwota);
            BigDecimal wynikPLN = waluta.przeliczNaZlote(kwota);
            
            System.out.println(kwota + " " + waluta.getCode() + " = " + wynikPLN + " PLN");
            System.out.println(kwota + " PLN = " + wynikWaluta + " " + waluta.getCode());
        }
    }

}
