package swing.zdarzenia;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Rozmowa2 {
	private static final Font FONT = new Font("Arial", Font.BOLD, 32);
	private static final Dimension odstep = new Dimension(0, 10);

	public static void main(String[] args) {
		JFrame okno = new JFrame("Rozmowa");
		okno.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		JPanel panel = new JPanel();
		okno.setContentPane(panel); // panel jest wnętrzem okna

		// panel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 5));
		panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));

		LayoutManager layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
		panel.setLayout(layout);

		JLabel pytanie = new JLabel("Jak masz na imię?");
		pytanie.setFont(FONT);
		panel.add(pytanie);

		panel.add(Box.createRigidArea(odstep));

		JTextField pole = new JTextField();
		pole.setFont(FONT);
		pole.setForeground(Color.MAGENTA);
		panel.add(pole);

		panel.add(Box.createRigidArea(odstep));

		JButton guzik = new JButton("OK");
		guzik.setFont(FONT);
		guzik.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
		panel.add(guzik);

		panel.add(Box.createRigidArea(odstep));

		JLabel powitanie = new JLabel("Witaj");
		powitanie.setFont(FONT);
		powitanie.setForeground(Color.BLUE);
		panel.add(powitanie);

		panel.add(Box.createRigidArea(odstep));

        JButton guzik2 = new JButton("Niespodzianka");
        guzik2.setFont(FONT);
        guzik2.setForeground(Color.RED);
        guzik2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        panel.add(guzik2);

        panel.add(Box.createRigidArea(odstep));
		okno.pack();
		
		// obsługa zdarzeń
        // dzięki umieszczeniu listenera w tym samym pliku (klasie), co całe okno, mamy dostęp do komponentów tego okna
		// klasa anonimowa
		guzik.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				String imie = pole.getText();
				powitanie.setText("Witaj " + imie);
				powitanie.setForeground(Color.BLUE);
			}
		});
		
		// obsługa naciśnięcia ENTER w polu tekstowym
        pole.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                String imie = pole.getText();
                powitanie.setText("Cześć " + imie);
                powitanie.setForeground(Color.GREEN);
            }
        });
        
        Random random = new Random();
        guzik2.addActionListener(evt -> {
            okno.getContentPane().setBackground(new Color(random.nextInt(0x1000000)));
            int x = okno.getX() + random.nextInt(400) - 200;
            int y = okno.getY() + random.nextInt(400) - 200;
            okno.setLocation(x, y);
        });
        
        // "adapter" to jest taka gotowa implementacja interfejsu,
        // która zawiera domyślne (zazwyczaj puste) implementacje wymaganych metod
        // nadoisujemy tylko te, które są nam potrzebne
        pole.addMouseListener(new MouseAdapter() {
        	@Override
        	public void mouseClicked(MouseEvent evt) {
        		if(evt.getButton() == MouseEvent.BUTTON3) {
        			int co = JOptionPane.showConfirmDialog(okno, "Czy chcesz wykasować?", "Pytanko", JOptionPane.YES_NO_OPTION);
        			if(co == JOptionPane.YES_OPTION) {
        				pole.setText("");
        				powitanie.setText("?");
        			}
        		}
        	}
		});

		okno.setVisible(true);
		System.out.println("okno wyświetlone, koniec main");
	}

}
