package swing.rysowanie;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Rysowanie {
	private JFrame okno;
	private PanelRysujacy panel;
	
	public void przygotujIWyswietl() {
		przygotujWyglad();
		ustawZdarzenia();
		dzialaj();
	}


	private void przygotujWyglad() {
		okno = new JFrame("Rysowanie");
		okno.setSize(400, 400);
		
		BoxLayout layout = new BoxLayout(okno.getContentPane(), BoxLayout.Y_AXIS);
		okno.setLayout(layout);

		panel = new PanelRysujacy();
		okno.add(panel);
		
	}

	private void ustawZdarzenia() {
		
	}

	private void dzialaj() {
		okno.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		okno.setVisible(true);		
	}


	public static void main(String[] args) {
		new Rysowanie().przygotujIWyswietl();
	}

	private static class PanelRysujacy extends JPanel {
		private int licznik = 0;
		
		@Override
		protected void paintComponent(Graphics g) {
			super.paintComponent(g);
			
			g.drawLine(10, 10, 30, 100);
			
			g.setColor(Color.RED);
			g.setFont(new Font("Tahoma", Font.BOLD, 32));
			g.drawString("Hello world", 50, 50);
			
			g.setColor(new Color(0xAA2288));
			
			g.fillOval(100, 20, 30, 30);
			
			licznik++;
			g.setColor(Color.BLUE);
			g.setFont(new Font("Tahoma", Font.BOLD, 24));
			g.drawString("Licznik: " + licznik, 200, 300);		
		}
	}
}
