package gotowe.p18_enkapsulacja.v4_po_zmianie;

public class Konto {
	private final int numer;
	private int saldo;
	private Osoba wlasciciel;

	public Konto(int numer, int saldo, Osoba wlasciciel) {
		if(saldo < 0) {
			throw new IllegalArgumentException("Saldo nie może być ujemne");
		}
		if(wlasciciel == null) {
			throw new IllegalArgumentException("Właściciel null");
		}
		this.numer = numer;
		this.saldo = saldo;
		this.wlasciciel = wlasciciel;
	}

	public int getNumer() {
		return numer;
	}

	public int getSaldo() {
		return saldo;
	}

	public Osoba getWlasciciel() {
		return wlasciciel;
	}

	public void setWlasciciel(Osoba wlasciciel) {
		this.wlasciciel = wlasciciel;
	}

	public String toString() {
		return "Konto nr " + numer + ", saldo: " + saldo + ", wł: " + wlasciciel;
	}
	
	// Jedynymi sposobami modyfikacji salda są metody wplata i wyplata.
	// Żadna inna klasa w projekcie, choćby było 1000 klas, nie modyfikuje salda z pominięciem tych metod.
	
	public void wplata(int kwota) {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Ujemna kwota we wplata");
		}
		saldo += kwota; // bezpieczniej byłoby saldo = Math.addExact(saldo, kwota)
	}
	
	public void wyplata(int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Ujemna kwota we wplata");
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Brak środków na koncie nr " + numer);
		}
		saldo -= kwota;
	}
	
}
