package emps.v3_funkcyjnie;

public class S2_Filtrowanie {

	// Program wypisuje tylko zarabiających >= 10 tys,
	// realizujemy to filtrowaniem, ale przy okazji pokazuję Wam schemat "filter / map" - podstawowe operacje na strumieniach.
	// W tej wersji wczytujemy dane strumieniowo prosto z pliku, bez tworzenia listy.
	public static void main(String[] args) {
		ObslugaCSV.wczytajStrumieniowo("emps.csv")
			.filter(emp -> emp.getSalary() >= 10_000)
			.map(emp -> emp.getFirstName() + " " + emp.getLastName() + " " + emp.getSalary())
			.map(String::toUpperCase) // ew.  .map(s -> s.toUpperCase())
			.forEach(System.out::println);
	}

}
