package gotowe.p40_io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Kopiuj1 {
	
	public static void kopiuj(String wejscie, String wyjscie) {
		InputStream is = null;
		OutputStream os = null;

		try {
			 is = new FileInputStream(wejscie);
			 os = new FileOutputStream(wyjscie);
			 
			 int licznik = 0;
			 int bajt;	 
			 while((bajt = is.read()) != -1) {
				 os.write(bajt);
				 //System.out.println(bajt);
				 licznik ++;
			 }
			System.out.println(licznik);
		} catch (FileNotFoundException e) {
			System.out.println("Plik nie znaleziony "+e.getMessage());
		} catch (IOException e) {
			System.out.println("Błąd wej/wyj "+e.getMessage());
		} finally {
			if(is != null)
				try { is.close(); } catch (IOException e) {	System.err.println(e.getMessage());}
			if(os != null)
				try { os.close(); } catch (IOException e) { System.err.println(e.getMessage()); }
		}
	}

	public static void main(String[] args) {

		long start = System.currentTimeMillis();
		kopiuj("pliki/pan_tadeusz.txt", "kopia1.txt");
		long koniec = System.currentTimeMillis();
		
		System.out.println("Koniec kopiowania, czas " + (koniec - start));
	}
}
