package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie1 {

	// W tej wersji widzimy klasyczny algorytm "agregacji danych za pomocą slownika"
	// Listę pracowników przeglądamy tylko raz, na bieżąco aktualizując słowniki.
	// W tej wersji używamy tylko podstawowych operacji na kolekcjach (sprzed Java 8)
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();

		for(Employee emp : emps) {
			if(sumy.containsKey(emp.getJobTitle())) {
				// to jest kolejny pracownik → jego pensję trzeba dodać do tego, co jest w słowniku
				int suma = sumy.get(emp.getJobTitle());
				sumy.put(emp.getJobTitle(), suma + emp.getSalary());
				int ile = ilosci.get(emp.getJobTitle());
				ilosci.put(emp.getJobTitle(), ile+1);
			} else {
				// to jest pierwszy pracownik z takim jobem → do słownika trzeba wpisać początkową wartość
				sumy.put(emp.getJobTitle(), emp.getSalary());
				ilosci.put(emp.getJobTitle(), 1);
			}
		}

		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		}
	}
}
