package gotowe.p12_dziedziczenie.a_podstawy;

import java.util.ArrayList;
import java.util.List;

// Klasa Student jest rozszerzeniem klasy Osoba.
// Klasa Student dziedziczy z klasy Osoba (inherits / inheritance).
// Klasa Osoba jest nadklasą (superclass), a klasa Student jest podklasą (subclass).
class Student extends Osoba {
    // Obiekt klasy Student będzie posiadał wzystkie pola zdefiniowane w klasie Osoba oraz wszystkie pola zdefiniowane tutaj.
    String kierunek;
    int rok;
    List<Integer> oceny = new ArrayList<>();

    Student() {
        // Tutaj kompilator wstawia automatycznie wywołanie konstruktora bezargumentowego z nadklasy
        // super();
    }

    Student(String imie, String nazwisko, int wiek, String kierunek, int rok) {
        // Jawne wywołanie konstruktora z nadklasy w celu przekazania do niego argumentów.
        super(imie, nazwisko, wiek);
        this.kierunek = kierunek;
        this.rok = rok;
    }

    // Jeśli chodzi o metody, podklasa może:
    // 1) nie zmieniać metod odziedziczonych z nadklasy
    // przykłady: pelnoletnia()

    // 2) dodać nowe metody, których nie było w nadklasie
    void dodajOcene(int ocena) {
        oceny.add(ocena);
    }

    double sredniaOcen() {
        int suma = 0;
        for(int ocena: oceny) {
            suma += ocena;
        }
        return 1. * suma / oceny.size();
    }

    // 3) nadpisać (override) metody, które były zdefiniowane w nadklasie
    // czyli dla istniejących metoda podać inną treść
    // adnotacja @Override jest w takich sytuacjach zalecana, ale nieobowiązkowa - bez niej wszystko też działa
    @Override
    void przedstawSie() {
        System.out.println(
                "Hej, tu " + imie + " " + nazwisko + ", studiuję na " + rok + " roku kierunku " + kierunek + ".");
    }

    @Override
    public String toString() {
        return super.toString() + ", student " + rok + " roku kierunku " + kierunek;
    }

}
