package emps.v3_funkcyjnie;

import java.util.List;

public class P1_WypiszDane {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Cel: wypisać wybrane pola.
		// Sposób 1: w wyrażeniu lambda napisać printa, który wypisuje wybrane rzeczy
		// emps.forEach(emp -> System.out.println(emp.getFirstName() + " " + emp.getLastName() + " " + emp.getSalary()));
		
		// Sposób 2, oparty o stream: najpierw mapujemy obiekty Employee na Stringi, a następnie wypisujemy te Stringi
		emps.stream()
			.map(emp -> emp.getFirstName() + " " + emp.getLastName() + " " + emp.getSalary())
			.forEach(System.out::println);
	}

}
