package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie4 {
	// W tej wersji używam operacji merge (od Java 8), która został wymyślona dokładnie po to,
	// aby rozwiązywać takie zadania, jak to.

	// merge(KLUCZ, WARTOSC, FUNKCJA) działa tak:
	// - jeśli w słowniku nie ma jeszcze niczego pod KLUCZem, to wstawiana jest tam WARTOSC
	// - jeśli w słowniku pod KLUCZem jest STARA_WARTOSC, to wywoływana jest FUNKCJA(STARA_WARTOSC, WARTOSC)
	//   a uzyskany wynik jest zapisywany z powrotem do słownika pod KLUCZ
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();

		for(Employee emp : emps) {
			sumy.merge(emp.getJobTitle(), emp.getSalary(), Integer::sum);
			ilosci.merge(emp.getJobTitle(), 1, Integer::sum);
		}

		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		}
	}

}
