package emps.v2_obiektowo;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

// Dla każdego jobTitle występującego w pliku,
// program oblicza średnią pensję pracowników na tym stanowisku.

// Ta wersja ma gorszą złożoność obliczeniową od pozostałych. Tutaj dla każdego joba ponownie przeglądana jest cała lista proacowników.
public class Grupowanie0 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		// etap 1: ustalenie zbioru jobów bez powtórzeń
		Set<String> jobs = new TreeSet<>();
		for(Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}
		// etap 2: dla każdego joba obliczamy średnią przeglądając wszystkoich pracowników i sprawdzając ifem
		for(String job : jobs) {
			double suma = 0;
			int ile = 0;
			
			for(Employee emp : emps) {
				if(job.equals(emp.getJobTitle())) {
					suma += emp.getSalary();
					ile++;
				}
			}
			double srednia = suma / ile;
			System.out.printf("%-32s | %2d | %8.2f%n", job, ile, srednia);
		}
	}

}
