package gotowe.p43_files;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

// To schodzi do podkatalogów
public class Wizytowanie {

	public static void main(String[] args) {
		try {
			Path start = Paths.get("src");
			MojWizytor visitor = new MojWizytor();
			
			Files.walkFileTree(start, visitor);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}

class MojWizytor extends SimpleFileVisitor<Path> {

	@Override
	public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs)
			throws IOException {
		System.out.println("preVisitDirectory "+dir);
		
		if("p10_klasy".equals(dir.getFileName().toString())) {
			System.out.println("p10_klasy - omijam");
			
			// Za pomocą wartości wynikowej sterujemy algorytmem - mówimy co ma robić dalej
			return FileVisitResult.SKIP_SUBTREE;
		} else
			return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult visitFile(Path file, BasicFileAttributes attrs)
			throws IOException {
		System.out.println("visitFile "+file.getFileName());
		if("Kopiuj1.java".equals(file.getFileName().toString())) {
			System.out.println("SKIP_SIBLINGS");
			return FileVisitResult.SKIP_SIBLINGS;
		} else
			return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult postVisitDirectory(Path dir, IOException exc)
			throws IOException {
		System.out.println("postVisitDirectory "+dir);
		return FileVisitResult.CONTINUE;
	}
	
	@Override
	public FileVisitResult visitFileFailed(Path file, IOException exc)
			throws IOException {
		System.out.println("visitFileFailed "+file);
		return FileVisitResult.TERMINATE;
	}

}
